from microbit import *
REGISTER_TA     =   0x06
REGISTER_TOBJ1  =   0x07
MLX90614addr    =   0x5a

class MLX90614():
    def read_temp(self, deviceAddress,register):
        buf = bytearray(2)
        i2c.write(deviceAddress,bytearray([register]),2)
        buf = i2c.read(deviceAddress,2)
        temp = buf[1] << 8 | buf[0]
        temp *= 0.02
        temp -= 273.15
        #temp = int.from_bytes(temp,'big')
        return temp

    def read_ambient_temperatureC(self):
        temp = self.read_temp(MLX90614addr,REGISTER_TA)
        return temp

    def read_object_temperatureC(self):
        temp = self.read_temp(MLX90614addr,REGISTER_TOBJ1)
        return temp

    def read_ambient_temperatureF(self):
        return self.read_ambient_temperatureC() * (9.0/5.0) + 32.0

    def read_object_temperatureF(self):
        return self.read_object_temperatureC() * (9.0/5.0) + 32.0

