from microbit import *
from neopixel import NeoPixel

class RGBMATRIX8x8():
    def init(self, pin):
        self.np = NeoPixel(pin, 64)
        self.color = (0,0,0)

    def clear(self):
        self.np.clear()

    def set(self, n, color=''):
        if color!='':
            self.np[n] = color
        else:
            self.np[n] = self.color
        self.np.show()

    def setcolor(self, color):
        self.color = color

    def show(self, dat,clear = True, color=''):
        if color != '':
            self.color = color
        if clear:
            for i in range(64):
                self.np[i]=(0,0,0)
        for y, line in enumerate(bytearray(dat)):
            for x in range(8):
                if line & (1 << x):
                    self.np[(7-x) + y * 8] = self.color
        self.np.show()