from microbit import *
import time

_COMMAND_BIT = 0x80

_REGISTER_ENABLE = 0x00
_REGISTER_ATIME = 0x01

_REGISTER_AILT = 0x04
_REGISTER_AIHT = 0x06

_REGISTER_ID = 0x12

_REGISTER_APERS = 0x0c

_REGISTER_CONTROL = 0x0f

_REGISTER_SENSORID = 0x12

_REGISTER_STATUS = 0x13
_REGISTER_CDATA = 0x14
_REGISTER_RDATA = 0x16
_REGISTER_GDATA = 0x18
_REGISTER_BDATA = 0x1a

_ENABLE_AIEN = 0x10
_ENABLE_WEN = 0x08
_ENABLE_AEN = 0x02
_ENABLE_PON = 0x01

TCS34725_INTEGRATIONTIME_2_4MS = 0xff
TCS34725_GAIN_4X = 0x01
TCS34725_GAIN_1X = 0x00
TCS34725_addr = 0x29

class TCS34725:
    def init(self):
        i2c.write(TCS34725_addr, bytearray([(_COMMAND_BIT | _REGISTER_ATIME), TCS34725_INTEGRATIONTIME_2_4MS]))
        i2c.write(TCS34725_addr, bytearray([(_COMMAND_BIT | _REGISTER_CONTROL), TCS34725_GAIN_4X]))
        i2c.write(TCS34725_addr, bytearray([(_COMMAND_BIT | _REGISTER_ENABLE), _ENABLE_PON]))
        sleep(10)
        i2c.write(TCS34725_addr, bytearray([(_COMMAND_BIT | _REGISTER_ENABLE), (_ENABLE_PON | _ENABLE_AEN)]))
    
    def get_clear_raw_data(self):
        i2c.write(TCS34725_addr, bytearray([_COMMAND_BIT | _REGISTER_CDATA]))
        sleep(5)
        clear = i2c.read(TCS34725_addr, 1)
        clear = int.from_bytes(clear, 'big')
        sleep(3)
        return clear
        
    def get_red_raw_data(self):
        i2c.write(0x29, bytearray([_COMMAND_BIT | _REGISTER_RDATA]))
        red = i2c.read(0x29, 1)
        red = int.from_bytes(red, 'big')
        sleep(3)
        clear = self.get_clear_raw_data()
        red = int((red / clear) * 255)
        return red

    def get_green_raw_data(self):
        i2c.write(0x29, bytearray([_COMMAND_BIT | _REGISTER_GDATA]))
        green = i2c.read(0x29, 1)
        green = int.from_bytes(green, 'big')
        sleep(3)
        clear = self.get_clear_raw_data()
        green = int((green / clear) * 255)
        return green

    def get_blue_raw_data(self):
        i2c.write(0x29, bytearray([_COMMAND_BIT | _REGISTER_BDATA]))
        blue = i2c.read(0x29, 1)
        blue = int.from_bytes(blue, 'big')
        sleep(3)
        clear = self.get_clear_raw_data()
        blue = int((blue / clear) * 255)
        return blue
		