from microbit import *

TSLaddr = 0x29      #Default I2C address, alternate 0x29, 0x49
TSLcmd = 0x80       #Command
TSLTiming = 0x81
TSLInterrupt = 0x86
chan0 = 0x8C        #Read Channel0 sensor date
chan1 = 0x8E        #Read channel1 sensor data
TSLon = 0x03        #Switch sensors on
TSLoff = 0x00       #Switch sensors off

CHSCALE_TINT0  = 0x7517

K1T = 0x0040   #0.125 * 2^RATIO_SCALE
B1T = 0x01f2   #0.0304 * 2^LUX_SCALE
M1T = 0x01be   #0.0272 * 2^LUX_SCALE
K2T = 0x0080   #0.250 * 2^RATIO_SCA
B2T = 0x0214   #0.0325 * 2^LUX_SCALE
M2T = 0x02d1   #0.0440 * 2^LUX_SCALE
K3T = 0x00c0   #0.375 * 2^RATIO_SCALE
B3T = 0x023f   #0.0351 * 2^LUX_SCALE
M3T = 0x037b   #0.0544 * 2^LUX_SCALE
K4T = 0x0100   #0.50 * 2^RATIO_SCALE
B4T = 0x0270   #0.0381 * 2^LUX_SCALE
M4T = 0x03fe   #0.0624 * 2^LUX_SCALE
K5T = 0x0138   #0.61 * 2^RATIO_SCALE
B5T = 0x016f   #0.0224 * 2^LUX_SCALE
M5T = 0x01fc   #0.0310 * 2^LUX_SCALE
K6T = 0x019a   #0.80 * 2^RATIO_SCALE
B6T = 0x00d2   #0.0128 * 2^LUX_SCALE
M6T = 0x00fb   #0.0153 * 2^LUX_SCALE
K7T = 0x029a   #1.3 * 2^RATIO_SCALE
B7T = 0x0018   #0.00146 * 2^LUX_SCALE
M7T = 0x0012   #0.00112 * 2^LUX_SCALE
K8T = 0x029a   #1.3 * 2^RATIO_SCALE
B8T = 0x0000   #0.000 * 2^LUX_SCALE
M8T = 0x0000   #0.000 * 2^LUX_SCALE

class TSL2561():
    def writeRegister(self,deviceAddress,address,val):
        #buf = address.to_bytes(2,'big')+val.to_bytes(2,'big')
        #i2c.write(deviceAddress,buf)
        i2c.write(deviceAddress, bytearray([address, val]))

    def readRegister(self,deviceAddress,address):
        i2c.write(deviceAddress, bytearray([address]))
        return i2c.read(deviceAddress,2)

    def init(self):
        self.writeRegister(TSLaddr, 0x00 | TSLcmd, TSLon) #Power On
        self.writeRegister(TSLaddr, 0x00 | TSLTiming, TSLoff) #Power On
        self.writeRegister(TSLaddr, 0x00 | TSLInterrupt, TSLoff) #Power On
        self.writeRegister(TSLaddr, 0x00 | TSLcmd, TSLon) #Power On

    def readVisibleLux(self):
        self.writeRegister(TSLaddr, 0x00 | TSLcmd, TSLon) #Power On
        sleep(14)
        #Read Ch0 Word
        data = self.readRegister(TSLaddr, chan0 | TSLcmd)
        #Read CH1 Word
        data1 = self.readRegister(TSLaddr, chan1 | TSLcmd)

        # Convert the data to Integer
        ch0 = data[1] * 256 + data[0]
        ch1 = data1[1] * 256 + data1[0]
        self.writeRegister(TSLaddr, 0x00 | TSLcmd, TSLoff) #switch off
        #ch0 out of range, but ch1 not. the lux is not valid in this situation.
        if ch0 / ch1 < 2 and ch0 > 4900:
            return -1;
        #calculateLux
        chScale = CHSCALE_TINT0
        chScale = chScale * 16
        channel0 = (ch0 * chScale) /1024
        channel1 = (ch1 * chScale) /1024
        if (channel0!= 0):
            ratio1 = (channel1 * 1024) / channel0;
        ratio = (ratio1 + 1) / 2;
        if (ratio >= 0) and (ratio <= K1T):
            b=B1T
            m=M1T
        elif (ratio <= K2T):
            b=B2T
            m=M2T
        elif (ratio <= K3T):
            b=B3T
            m=M3T
        elif (ratio <= K4T):
            b=B4T
            m=M4T
        elif (ratio <= K5T):
            b=B5T
            m=M5T
        elif (ratio <= K6T):
            b=B6T
            m=M6T
        elif (ratio <= K7T):
            b=B7T
            m=M7T
        elif (ratio > K8T):
            b=B8T
            m=M8T
        temp=((channel0*b)-(channel1*m))
        if temp<0:
            temp=0
        temp += 8192;
        lux = int(temp / 16384);
        return lux