from microbit import *

class pn532:
    def connect(self):
        i2c.init(100000)

    def scan_i2c(self):
        return i2c.scan()

    def wait_ack(self,pn532_addr):
        while True:
            data = i2c.read(pn532_addr, 12)
            ack = str(data).replace('\\x', ' ').replace("b'", '').strip()
            if ack[0:11] == '01 00 00 ff':
                if ack[0:20] == '01 00 00 ff 00 ff 00':
                    return True
                else:
                    return False
            sleep(200)	

    def read(self,addr, leng=30):
        rbytes = i2c.read(addr, leng)
        result = str(rbytes).replace('\\x', ' ').replace("b'", '').strip()
        if result[0:11] == '01 00 00 ff':
            return rbytes
        else:
            return False

    def write(self,addr, cmd):
            i2c.write(addr, cmd)
            sleep(100)
            if self.wait_ack(addr):
                return True
            else:
                return False

    def get_version(self,addr):
        cmd_version = bytearray(b'\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xFF\x02\xFE\xD4\x02\x2A')
        try:
            self.connect()
        except Exception:
            display.show('Check i2c line')
            return False
        if self.write(addr, cmd_version):
            return self.read(addr)

    def config_pn532(self,addr):
        cmd_config = bytearray(b'\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xFF\x05\xFB\xD4\x14\x01\x02\x01\x14')
        if self.write(addr, cmd_config):
            return True
        else:
            return False

    def wait_card(self,addr):
        if not self.config_pn532(addr):
            return False
        cmd_waitcard = bytearray(b'\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xFF\x04\xFC\xD4\x4A\x01\x00\xE1')
        if self.write(addr, cmd_waitcard):
            while True:
                result = self.read(addr, leng=100)
                if result:
                    card_num = ''
                    ll = result[13]
                    st = 0
                    while st < ll:
                        card_num += str('%02x' % result[14+st])
                        st = st + 1
                    return card_num
                sleep(200)
        else:
            return False

