from microbit import *

INA219addr                              =   0x40
INA219_REG_CONFIG                       =   0x00
INA219_CONFIG_BVOLTAGERANGE_32V         =   0x2000
INA219_CONFIG_GAIN_8_320MV              =   0x1800
INA219_CONFIG_BADCRES_12BIT             =   0x0400
INA219_CONFIG_SADCRES_12BIT_1S_532US    =   0x0018
INA219_CONFIG_MODE_SANDBVOLT_CONTINUOUS =   0x0007
INA219_REG_SHUNTVOLTAGE                 =   0x01
INA219_REG_BUSVOLTAGE                   =   0x02
INA219_REG_CURRENT                      =   0x04
INA219_REG_CALIBRATION                  =   0x05

class INA219():
    def writeRegister(self,deviceAddress,address,value):
        buf = bytearray(2)
        buf[0] = (value >> 8) & 0xFF
        buf[1] = value & 0xFF
        i2c.write(deviceAddress, bytearray([address, buf[0], buf[1]]))

    def readRegister(self,deviceAddress,address):
        i2c.write(deviceAddress, bytearray([address]))
        return i2c.read(deviceAddress,2)

    def begin(self):
        self.ina219_calValue = 4096
        self.writeRegister(INA219addr,INA219_REG_CALIBRATION, self.ina219_calValue)
        config = (INA219_CONFIG_BVOLTAGERANGE_32V | INA219_CONFIG_GAIN_8_320MV | INA219_CONFIG_BADCRES_12BIT | INA219_CONFIG_SADCRES_12BIT_1S_532US |INA219_CONFIG_MODE_SANDBVOLT_CONTINUOUS)
        self.writeRegister(INA219addr,INA219_REG_CONFIG, config)

    def getCurrent_mA(self):
        self.writeRegister(INA219addr,INA219_REG_CALIBRATION, self.ina219_calValue)
        value = self.readRegister(INA219addr, INA219_REG_CURRENT)
        #print(value)
        value = int.from_bytes(value,'big')
        if value > 32767:
                value -= 65535
        value = value / 10
        return value

    def getBusVoltage_V(self):
        value = self.readRegister(INA219addr, INA219_REG_BUSVOLTAGE)
        value = int.from_bytes(value,'big')
        value = value / 8 * 4 * 0.001
        return value

    def getShuntVoltage_mV(self):
        value = self.readRegister(INA219addr, INA219_REG_SHUNTVOLTAGE)
        value = int.from_bytes(value,'big')
        if value > 32767:
            value -= 65535
        value = value * 0.01
        return value

    def getPower_mW(self):
        self.writeRegister(INA219addr,INA219_REG_CALIBRATION, self.ina219_calValue)
        value = self.readRegister(INA219addr, INA219_REG_POWER)
        value = int.from_bytes(value,'big')
        value = value * 2
        return value