from microbit import *

class eeprom:

    def weep(self, eepAdr, value):
        data = bytearray(3)
        data[0]=eepAdr >> 8 #msb
        data[1]=eepAdr & 0xFF #lsb
        data[2]=value
        i2c.write(0x50, data, repeat = False)
        sleep(20)
        return("OK")

    def reep(self,eepAdr, num = 1):
        data = bytearray(2)
        data[0]=eepAdr >> 8
        data[1]=eepAdr & 0xFF
        i2c.write(0x50, data)
        value = (i2c.read(0x50, num, repeat=False))
        return int.from_bytes(value,'little')
