from microbit import *

class ML8511:
    def getuv(self,ENpin,OUTpin):
        self.enpin = ENpin
        self.outpin = OUTpin
        uvLevel = self.averageAnalogRead(self.enpin)
        refLevel = self.averageAnalogRead(self.outpin)
        outputVoltage = 3.3 / refLevel * uvLevel
        uvIntensity = self.mapfloat(outputVoltage, 0.99, 2.8, 0.0, 15.0);
        return uvIntensity

    def averageAnalogRead(self,pinToRead):
        numberOfReadings = 8
        runningValue = 0
        for i in range(numberOfReadings):
            runningValue += pinToRead.read_analog()
        runningValue /= numberOfReadings
        return runningValue

    def mapfloat(self,x,in_min,in_max,out_min,out_max):
        return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;