from microbit import *

# LCD Control constants
ADDR = 0x3C
screen = bytearray(1024)  # send byte plus pixels
screen[0]= 0x40
zoom = 1
class SH1106():
    def command(self,c):
        i2c.write(ADDR, b'\x00' + bytearray(c))

    def initialize(self):
        cmd = [
        [0xAE],         # SSD1306_DISPLAYOFF
        [0x8D,0x00,0x10],         # SSD1306_DISPLAYALLON_RESUME
        [0x40,0x81],   # SSD1306_SETDISPLAYCLOCKDIV
        [0xCF, 0xA0,0xC0],   # SSD1306_SETDISPLAYOFFSET
        [0xA1,0xC8],
        [0xA6],
        [0xA8,0x3F],   # SSD1306_CHARGEPUMP
        [0xD3],   # SSD1306_MEMORYMODE
        [0x00], # SSD1306_COLUMNADDR
        [0xD5, 0x80],  # SSD1306_PAGEADDR
        [0xD9 , 0xF1],   # SSD1306_SEGREMAP
        [0xD1,0x12],         # SSD1306_COMSCANDEC
        [0xDB,0x40],
        [0x8D,0x14],
        [0xAF]          # SSD1306_DISPLAYON
        ]
        for c in cmd:
            self.command(c)
        self.clear_oled()


    def set_pos(self,col=0, page=0):
        self.command([0xb0 | page])  # page number
        # take upper and lower value of col * 2
        c1, c2 = col * 2 & 0x0F, col >> 3
        self.command([0x02 | c1])  # lower start column address
        self.command([0x10 | c2])  # upper start column address

    def clear_oled(self,c=0):
        global screen
        for i in range(1, 1024):
            screen[i] = 0
        self.draw_screen()

    def set_zoom(self,v):
        global zoom
        if zoom != v:
            self.command([0xd6, v])  # zoom on/off
            self.command([0xa7 - v])  # inverted display
            zoom = v

    def draw_screen(self):
        self.set_zoom(1)
        i2c.write(ADDR, screen)

    def add_text(self,x, y, text, draw=1):
        for i in range(0, min(len(text), 12 - x)):
            for c in range(0, 5):
                col = 0
                for r in range(1, 6):
                    p = Image(text[i]).get_pixel(c, r - 1)
                    col = col | (1 << r) if (p != 0) else col
                ind = x * 10 + y * 128 + i * 10 + c * 2 + 1
                screen[ind], screen[ind + 1] = col, col
        if draw == 1:
            self.set_zoom(1)
            self.set_pos(x * 8, y )
            ind0 = x * 10 + y * 128 + 1
            i2c.write(ADDR, b'\x40' + screen[ind0:ind + 1])












