from microbit import *

VL53L0X_REG_IDENTIFICATION_MODEL_ID		    = 0x00c0
VL53L0X_REG_IDENTIFICATION_REVISION_ID		= 0x00c2
VL53L0X_REG_PRE_RANGE_CONFIG_VCSEL_PERIOD	= 0x0050
VL53L0X_REG_FINAL_RANGE_CONFIG_VCSEL_PERIOD	= 0x0070
VL53L0X_REG_SYSRANGE_START			        = 0x000
VL53L0X_REG_RESULT_INTERRUPT_STATUS 		= 0x0013
VL53L0X_REG_RESULT_RANGE_STATUS 		    = 0x0014
VL53L0X_REG_SYSTEM_INTERRUPT_CLEAR          = 0x0B
VL53L0X_address                             = 0x29
distance_temp                               = 0

class VL53L0X():
    def writeRegister(self,deviceAddress,address,val):
        i2c.write(deviceAddress, bytearray([address, val]))

    def readRegister(self,deviceAddress,address):
        i2c.write(deviceAddress, bytearray([address]))
        return i2c.read(deviceAddress,1)

    def readRegister_block(self,deviceAddress,address):
        i2c.write(deviceAddress, bytearray([address]))
        return i2c.read(deviceAddress,12)

    def makeuint16(self,lsb, msb):
        return ((msb & 0xFF) << 8)  | (lsb & 0xFF)

    def getDistance(self):
        global distance_temp
        self.writeRegister(VL53L0X_address,VL53L0X_REG_SYSRANGE_START, 0x01)
        data = self.readRegister_block(VL53L0X_address, VL53L0X_REG_RESULT_RANGE_STATUS)
        distance = self.makeuint16(data[11], data[10])
        self.writeRegister(VL53L0X_address,VL53L0X_REG_SYSTEM_INTERRUPT_CLEAR, 0x01)
        if distance == 20:
            distance = distance_temp
        else:
            distance_temp = distance
        return distance - 100