# Distributed with a free-will license.
# Use it any way you want, profit or free, provided it fits in the licenses of its associated works.
# PCA9536
# This code is designed to work with the PCA9536_I2CIO I2C Mini Module available from ControlEverything.com.
# https://www.controleverything.com/content/Digital-IO?sku=PCA9536_I2CIO#tabs-0-product_tabset-2

import smbus
import time

# Get I2C bus
bus = smbus.SMBus(1)

# I2C address of the device
PCA9536_DEFAULT_ADDRESS = 0x41

# PCA9536 Register Map
PCA9536_REG_INPUT = 0x00 # Input Port Register
PCA9536_REG_OUTPUT = 0x01 # Output Port Register
PCA9536_REG_POLARITY= 0x02 # Polarity Inversion Register
PCA9536_REG_CONFIG = 0x03 # Configuration Register

# PCA9536 Output Port Register Configuration
PCA9536_OUTPUT_PIN0 = 0x01 # Reflects outgoing logic levels of Pin-0
PCA9536_OUTPUT_PIN1 = 0x02 # Reflects outgoing logic levels of Pin-1
PCA9536_OUTPUT_PIN2 = 0x04 # Reflects outgoing logic levels of Pin-2
PCA9536_OUTPUT_PIN3 = 0x08 # Reflects outgoing logic levels of Pin-3

# PCA9536 Polarity Inversion Register Configuration
PCA9536_POLARITY_PIN0 = 0x01 # Input Port register data inverted of Pin-0
PCA9536_POLARITY_PIN1 = 0x02 # Input Port register data inverted of Pin-1
PCA9536_POLARITY_PIN2 = 0x04 # Input Port register data inverted of Pin-2
PCA9536_POLARITY_PIN3 = 0x08 # Input Port register data inverted of Pin-3
PCA9536_POLARITY_PINX = 0x00 # Input Port register data retained of Pin-X

# PCA9536 Configuration Register 
PCA9536_CONFIG_PIN0 = 0x01 # Corresponding port Pin-0 configured as Input
PCA9536_CONFIG_PIN1 = 0x02 # Corresponding port Pin-1 configured as Input
PCA9536_CONFIG_PIN2 = 0x04 # Corresponding port Pin-2 configured as Input
PCA9536_CONFIG_PIN3 = 0x08 # Corresponding port Pin-3 configured as Input
PCA9536_CONFIG_PINX = 0x00 # Corresponding port Pin-X configured as Output

class PCA9536():        
    def input_output_config(self,pins,state):
        if state == 0 :
            if pins == 0 :
                bus.write_byte_data(PCA9536_DEFAULT_ADDRESS, PCA9536_REG_CONFIG, PCA9536_CONFIG_PIN0)
            elif pins == 1 :
                bus.write_byte_data(PCA9536_DEFAULT_ADDRESS, PCA9536_REG_CONFIG, PCA9536_CONFIG_PIN1)
            elif pins == 2 :
                bus.write_byte_data(PCA9536_DEFAULT_ADDRESS, PCA9536_REG_CONFIG, PCA9536_CONFIG_PIN2)
            elif pins== 3 :
                bus.write_byte_data(PCA9536_DEFAULT_ADDRESS, PCA9536_REG_CONFIG, PCA9536_CONFIG_PIN3)
        elif state == 1 :
            bus.write_byte_data(PCA9536_DEFAULT_ADDRESS, PCA9536_REG_OUTPUT, PCA9536_CONFIG_PINX)
            bus.write_byte_data(PCA9536_DEFAULT_ADDRESS, PCA9536_REG_CONFIG, PCA9536_CONFIG_PINX)
        
    def read_data(self,pins,state):
        if pins == 0 :
            pin_num = PCA9536_CONFIG_PIN0
        if pins == 1 :
            pin_num = PCA9536_CONFIG_PIN1
        if pins == 2 :
            pin_num = PCA9536_CONFIG_PIN2
        if pins == 3 :
            pin_num = PCA9536_CONFIG_PIN3
        data = bus.read_byte_data(PCA9536_DEFAULT_ADDRESS, PCA9536_REG_OUTPUT)
        if state == 1:
            print('1')
            data |= (data | pin_num)
            bus.write_byte_data(PCA9536_DEFAULT_ADDRESS, PCA9536_REG_OUTPUT,data)
        elif state == 0:
            print('0')
            data &= ~(1 << data | pin_num)
            bus.write_byte_data(PCA9536_DEFAULT_ADDRESS, PCA9536_REG_OUTPUT, data)
